'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
class ValueSource {
  constructor(props) {
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "isCompatible", () => {
      return !!(this.props.name || this.props.value || this.props.email);
    });
    (0, _defineProperty2.default)(this, "get", setState => {
      const value = this.getValue();
      if (!value) return setState(null);
      setState({
        sourceName: 'text',
        value: value,
        color: this.getColor()
      });
    });
    this.props = props;
  }
  getInitials() {
    const {
      name,
      initials
    } = this.props;
    if (typeof initials === 'string') return initials;
    if (typeof initials === 'function') return initials(name, this.props);
    return (0, _utils.defaultInitials)(name, this.props);
  }
  getValue() {
    if (this.props.name) return this.getInitials();
    if (this.props.value) return this.props.value;
    return null;
  }
  getColor() {
    const {
      color,
      colors,
      name,
      email,
      value
    } = this.props;
    const colorValue = name || email || value;
    return color || (0, _utils.getRandomColor)(colorValue, colors);
  }
}
exports.default = ValueSource;
(0, _defineProperty2.default)(ValueSource, "propTypes", {
  color: _propTypes.default.string,
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  email: _propTypes.default.string,
  maxInitials: _propTypes.default.number,
  initials: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func])
});