'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _md = _interopRequireDefault(require("md5"));
var _utils = require("../utils");
class GravatarSource {
  constructor(_props) {
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "isCompatible", () => {
      return !!this.props.email || !!this.props.md5Email;
    });
    (0, _defineProperty2.default)(this, "get", setState => {
      const {
        props
      } = this;
      const email = props.md5Email || (0, _md.default)(props.email);
      const size = (0, _utils.getImageSize)(props.size);
      let url = "https://secure.gravatar.com/avatar/".concat(email, "?d=404");
      if (size) url += "&s=".concat(size);
      setState({
        sourceName: 'gravatar',
        src: url
      });
    });
    this.props = _props;
  }
}
exports.default = GravatarSource;
(0, _defineProperty2.default)(GravatarSource, "propTypes", {
  email: _propTypes.default.string,
  md5Email: _propTypes.default.string
});