'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
class GithubSource {
  constructor(props) {
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "isCompatible", () => !!this.props.githubHandle);
    (0, _defineProperty2.default)(this, "get", setState => {
      const {
        githubHandle
      } = this.props;
      const size = (0, _utils.getImageSize)(this.props.size);
      let url = "https://avatars.githubusercontent.com/".concat(githubHandle, "?v=4");
      if (size) url += "&s=".concat(size);
      setState({
        sourceName: 'github',
        src: url
      });
    });
    this.props = props;
  }
}
exports.default = GithubSource;
(0, _defineProperty2.default)(GithubSource, "propTypes", {
  githubHandle: _propTypes.default.string
});