'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
class FacebookSource {
  constructor(props) {
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "isCompatible", () => !!this.props.facebookId);
    (0, _defineProperty2.default)(this, "get", setState => {
      const {
        facebookId
      } = this.props;
      const size = (0, _utils.getImageSize)(this.props.size);
      let url = "https://graph.facebook.com/".concat(facebookId, "/picture");
      if (size) url += "?width=".concat(size, "&height=").concat(size);
      setState({
        sourceName: 'facebook',
        src: url
      });
    });
    this.props = props;
  }
}
exports.default = FacebookSource;
(0, _defineProperty2.default)(FacebookSource, "propTypes", {
  facebookId: _propTypes.default.string
});