'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createRedirectSource;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
function createRedirectSource(network, property) {
  var _AvatarRedirectSource;
  return _AvatarRedirectSource = class AvatarRedirectSource {
    constructor(props) {
      (0, _defineProperty2.default)(this, "props", null);
      (0, _defineProperty2.default)(this, "isCompatible", () => {
        return !!this.props.avatarRedirectUrl && !!this.props[property];
      });
      (0, _defineProperty2.default)(this, "get", setState => {
        const {
          avatarRedirectUrl
        } = this.props;
        const size = (0, _utils.getImageSize)(this.props.size);
        const baseUrl = avatarRedirectUrl.replace(/\/*$/, '/');
        const id = this.props[property];
        const query = size ? "size=".concat(size) : '';
        const src = "".concat(baseUrl).concat(network, "/").concat(id, "?").concat(query);
        setState({
          sourceName: network,
          src
        });
      });
      this.props = props;
    }
  }, (0, _defineProperty2.default)(_AvatarRedirectSource, "propTypes", {
    [property]: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
  }), _AvatarRedirectSource;
}