"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withConfig = exports.ConfigProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _cache = _interopRequireDefault(require("./cache"));
var _utils = require("./utils");
const defaults = {
  cache: _cache.default,
  colors: _utils.defaultColors,
  initials: _utils.defaultInitials,
  avatarRedirectUrl: null
};
const contextKeys = Object.keys(defaults);

/**
 * withConfig and ConfigProvider provide a compatibility layer for different
 * versions of React equiped with different versions of the Context API.
 *
 * If the new Context API is available it will be used, otherwise we will
 * fall back to the legacy context api.
 */

const ConfigContext = _react.default.createContext && /*#__PURE__*/_react.default.createContext();
const isLegacyContext = !ConfigContext;
const ConfigConsumer = isLegacyContext ? null : ConfigContext.Consumer;

/**
 * This was introduced in React 16.3.0 we need this to
 * prevent errors in newer versions. But we will just forward the
 * component for any version lower than 16.3.0
 *
 * https://github.com/Sitebase/react-avatar/issues/201
 * https://github.com/facebook/react/blob/master/CHANGELOG.md#1630-march-29-2018
 */
const forwardRef = _react.default.forwardRef || (C => C);
class ConfigProvider extends _react.default.Component {
  _getContext() {
    const context = {};
    contextKeys.forEach(key => {
      if (typeof this.props[key] !== 'undefined') context[key] = this.props[key];
    });
    return context;
  }
  render() {
    const {
      children
    } = this.props;
    if (isLegacyContext) return _react.default.Children.only(children);
    return /*#__PURE__*/_react.default.createElement(ConfigContext.Provider, {
      value: this._getContext()
    }, _react.default.Children.only(children));
  }
}
exports.ConfigProvider = ConfigProvider;
(0, _defineProperty2.default)(ConfigProvider, "displayName", 'ConfigProvider');
(0, _defineProperty2.default)(ConfigProvider, "propTypes", {
  cache: _propTypes.default.object,
  colors: _propTypes.default.arrayOf(_propTypes.default.string),
  initials: _propTypes.default.func,
  avatarRedirectUrl: _propTypes.default.string,
  children: _propTypes.default.node
});
const withConfig = Component => {
  function withAvatarConfig(props, refOrContext) {
    // If legacy context is enabled, there is no support for forwardedRefs either
    if (isLegacyContext) {
      const ctx = refOrContext && refOrContext.reactAvatar;
      return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, defaults, ctx, props));
    }

    /* eslint-disable react/display-name */
    return /*#__PURE__*/_react.default.createElement(ConfigConsumer, null, config => /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
      ref: refOrContext
    }, defaults, config, props)));
    /* eslint-enable react/display-name */
  }

  // Legacy support, only set when legacy is detected
  withAvatarConfig.contextTypes = ConfigProvider.childContextTypes;
  return forwardRef(withAvatarConfig);
};
exports.withConfig = withConfig;
if (isLegacyContext) {
  ConfigProvider.childContextTypes = {
    reactAvatar: _propTypes.default.object
  };
  ConfigProvider.prototype.getChildContext = function () {
    return {
      reactAvatar: this._getContext()
    };
  };
}