"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
class AvatarWrapper extends _react.default.PureComponent {
  render() {
    const {
      className,
      unstyled,
      round,
      style,
      avatar,
      onClick,
      children
    } = this.props;
    const {
      sourceName
    } = avatar;
    const size = (0, _utils.parseSize)(this.props.size);
    const hostStyle = unstyled ? null : {
      display: 'inline-block',
      verticalAlign: 'middle',
      width: size.str,
      height: size.str,
      borderRadius: (0, _utils.calculateBorderRadius)(round),
      fontFamily: 'Helvetica, Arial, sans-serif',
      ...style
    };
    const classNames = [className, 'sb-avatar'];
    if (sourceName) {
      const source = sourceName.toLowerCase().replace(/[^a-z0-9-]+/g, '-') // only allow alphanumeric
      .replace(/^-+|-+$/g, ''); // trim `-`
      classNames.push('sb-avatar--' + source);
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: classNames.join(' '),
      onClick: onClick,
      style: hostStyle
    }, children);
  }
}
exports.default = AvatarWrapper;
(0, _defineProperty2.default)(AvatarWrapper, "propTypes", {
  className: _propTypes.default.string,
  round: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.string]),
  style: _propTypes.default.object,
  size: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  unstyled: _propTypes.default.bool,
  avatar: _propTypes.default.object,
  onClick: _propTypes.default.func,
  children: _propTypes.default.node
});