"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../utils");
var _wrapper = _interopRequireDefault(require("./wrapper"));
class AvatarImage extends _react.default.PureComponent {
  render() {
    const {
      className,
      round,
      unstyled,
      alt,
      title,
      name,
      value,
      avatar
    } = this.props;
    const size = (0, _utils.parseSize)(this.props.size);
    const imageStyle = unstyled ? null : {
      maxWidth: '100%',
      width: size.str,
      height: size.str,
      borderRadius: (0, _utils.calculateBorderRadius)(round)
    };
    return /*#__PURE__*/_react.default.createElement(_wrapper.default, this.props, /*#__PURE__*/_react.default.createElement("img", {
      className: className + ' sb-avatar__image',
      width: size.str,
      height: size.str,
      style: imageStyle,
      src: avatar.src,
      alt: (0, _utils.getNullableText)(alt, name || value),
      title: (0, _utils.getNullableText)(title, name || value),
      onError: avatar.onRenderFailed
    }));
  }
}
exports.default = AvatarImage;
(0, _defineProperty2.default)(AvatarImage, "propTypes", {
  alt: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
  title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  avatar: _propTypes.default.object,
  className: _propTypes.default.string,
  unstyled: _propTypes.default.bool,
  round: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.string, _propTypes.default.number]),
  size: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
});
(0, _defineProperty2.default)(AvatarImage, "defaultProps", {
  className: '',
  round: false,
  size: 100,
  unstyled: false
});