'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Cache", {
  enumerable: true,
  get: function () {
    return _cache.Cache;
  }
});
Object.defineProperty(exports, "ConfigProvider", {
  enumerable: true,
  get: function () {
    return _context.ConfigProvider;
  }
});
exports.default = createAvatarComponent;
Object.defineProperty(exports, "getRandomColor", {
  enumerable: true,
  get: function () {
    return _utils.getRandomColor;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _cache = require("./cache");
var _context = require("./context");
var _dataProvider = _interopRequireDefault(require("./data-provider"));
var _utils = require("./utils");
var _image = _interopRequireDefault(require("./components/image"));
var _text = _interopRequireDefault(require("./components/text"));
function createAvatarComponent(options) {
  const DataProvider = (0, _dataProvider.default)(options);
  const Component = (0, _context.withConfig)(
  /*#__PURE__*/
  // eslint-disable-next-line react/display-name
  _react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(DataProvider, (0, _extends2.default)({}, props, {
    propertyName: "avatar"
  }), avatar => {
    const Avatar = avatar.src ? _image.default : _text.default;
    return /*#__PURE__*/_react.default.createElement(Avatar, (0, _extends2.default)({}, props, {
      avatar: avatar,
      ref: ref
    }));
  })));
  return Object.assign(Component, {
    getRandomColor: _utils.getRandomColor,
    ConfigProvider: _context.ConfigProvider,
    Cache: _cache.Cache
  });
}