'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import { getRandomColor, defaultInitials } from '../utils';
export default class ValueSource {
  constructor(props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "isCompatible", () => {
      return !!(this.props.name || this.props.value || this.props.email);
    });
    _defineProperty(this, "get", setState => {
      const value = this.getValue();
      if (!value) return setState(null);
      setState({
        sourceName: 'text',
        value: value,
        color: this.getColor()
      });
    });
    this.props = props;
  }
  getInitials() {
    const {
      name,
      initials
    } = this.props;
    if (typeof initials === 'string') return initials;
    if (typeof initials === 'function') return initials(name, this.props);
    return defaultInitials(name, this.props);
  }
  getValue() {
    if (this.props.name) return this.getInitials();
    if (this.props.value) return this.props.value;
    return null;
  }
  getColor() {
    const {
      color,
      colors,
      name,
      email,
      value
    } = this.props;
    const colorValue = name || email || value;
    return color || getRandomColor(colorValue, colors);
  }
}
_defineProperty(ValueSource, "propTypes", {
  color: PropTypes.string,
  name: PropTypes.string,
  value: PropTypes.string,
  email: PropTypes.string,
  maxInitials: PropTypes.number,
  initials: PropTypes.oneOfType([PropTypes.string, PropTypes.func])
});