'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
export default class SkypeSource {
  constructor(props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "isCompatible", () => !!this.props.skypeId);
    _defineProperty(this, "get", setState => {
      const {
        skypeId
      } = this.props;
      const url = "https://api.skype.com/users/".concat(skypeId, "/profile/avatar");
      setState({
        sourceName: 'skype',
        src: url
      });
    });
    this.props = props;
  }
}
_defineProperty(SkypeSource, "propTypes", {
  skypeId: PropTypes.string
});