'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import { getRandomColor } from '../utils';
export default class IconSource {
  constructor(props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "icon", '✷');
    _defineProperty(this, "isCompatible", () => true);
    _defineProperty(this, "get", setState => {
      const {
        color,
        colors
      } = this.props;
      setState({
        sourceName: 'icon',
        value: this.icon,
        color: color || getRandomColor(this.icon, colors)
      });
    });
    this.props = props;
  }
}
_defineProperty(IconSource, "propTypes", {
  color: PropTypes.string
});