'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import md5 from 'md5';
import { getImageSize } from '../utils';
export default class GravatarSource {
  constructor(_props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "isCompatible", () => {
      return !!this.props.email || !!this.props.md5Email;
    });
    _defineProperty(this, "get", setState => {
      const {
        props
      } = this;
      const email = props.md5Email || md5(props.email);
      const size = getImageSize(props.size);
      let url = "https://secure.gravatar.com/avatar/".concat(email, "?d=404");
      if (size) url += "&s=".concat(size);
      setState({
        sourceName: 'gravatar',
        src: url
      });
    });
    this.props = _props;
  }
}
_defineProperty(GravatarSource, "propTypes", {
  email: PropTypes.string,
  md5Email: PropTypes.string
});