'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import { getImageSize } from '../utils';
export default class GithubSource {
  constructor(props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "isCompatible", () => !!this.props.githubHandle);
    _defineProperty(this, "get", setState => {
      const {
        githubHandle
      } = this.props;
      const size = getImageSize(this.props.size);
      let url = "https://avatars.githubusercontent.com/".concat(githubHandle, "?v=4");
      if (size) url += "&s=".concat(size);
      setState({
        sourceName: 'github',
        src: url
      });
    });
    this.props = props;
  }
}
_defineProperty(GithubSource, "propTypes", {
  githubHandle: PropTypes.string
});