'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import { getImageSize } from '../utils';
export default class FacebookSource {
  constructor(props) {
    _defineProperty(this, "props", null);
    _defineProperty(this, "isCompatible", () => !!this.props.facebookId);
    _defineProperty(this, "get", setState => {
      const {
        facebookId
      } = this.props;
      const size = getImageSize(this.props.size);
      let url = "https://graph.facebook.com/".concat(facebookId, "/picture");
      if (size) url += "?width=".concat(size, "&height=").concat(size);
      setState({
        sourceName: 'facebook',
        src: url
      });
    });
    this.props = props;
  }
}
_defineProperty(FacebookSource, "propTypes", {
  facebookId: PropTypes.string
});