'use strict';

import _defineProperty from "@babel/runtime/helpers/defineProperty";
import PropTypes from 'prop-types';
import { getImageSize } from '../utils';
export default function createRedirectSource(network, property) {
  var _AvatarRedirectSource;
  return _AvatarRedirectSource = class AvatarRedirectSource {
    constructor(props) {
      _defineProperty(this, "props", null);
      _defineProperty(this, "isCompatible", () => {
        return !!this.props.avatarRedirectUrl && !!this.props[property];
      });
      _defineProperty(this, "get", setState => {
        const {
          avatarRedirectUrl
        } = this.props;
        const size = getImageSize(this.props.size);
        const baseUrl = avatarRedirectUrl.replace(/\/*$/, '/');
        const id = this.props[property];
        const query = size ? "size=".concat(size) : '';
        const src = "".concat(baseUrl).concat(network, "/").concat(id, "?").concat(query);
        setState({
          sourceName: network,
          src
        });
      });
      this.props = props;
    }
  }, _defineProperty(_AvatarRedirectSource, "propTypes", {
    [property]: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
  }), _AvatarRedirectSource;
}