'use strict';

import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import { Cache } from './cache';
import { withConfig, ConfigProvider } from './context';
import createAvatarDataProvider from './data-provider';
import { getRandomColor } from './utils';
import Image from './components/image';
import Text from './components/text';
export { getRandomColor } from './utils';
export { ConfigProvider } from './context';
export { Cache } from './cache';
export default function createAvatarComponent(options) {
  const DataProvider = createAvatarDataProvider(options);
  const Component = withConfig(
  /*#__PURE__*/
  // eslint-disable-next-line react/display-name
  React.forwardRef((props, ref) => /*#__PURE__*/React.createElement(DataProvider, _extends({}, props, {
    propertyName: "avatar"
  }), avatar => {
    const Avatar = avatar.src ? Image : Text;
    return /*#__PURE__*/React.createElement(Avatar, _extends({}, props, {
      avatar: avatar,
      ref: ref
    }));
  })));
  return Object.assign(Component, {
    getRandomColor,
    ConfigProvider,
    Cache
  });
}